/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer;
import com.badlogic.gdx.graphics.glutils.GLOnlyTextureData;

public class FrameBuffer
extends GLFrameBuffer<Texture> {
    public FrameBuffer(Pixmap.Format format2, int width, int height, boolean hasDepth) {
        this(format2, width, height, hasDepth, false);
    }

    public FrameBuffer(Pixmap.Format format2, int width, int height, boolean hasDepth, boolean hasStencil) {
        super(format2, width, height, hasDepth, hasStencil);
    }

    @Override
    protected Texture createColorTexture() {
        int glFormat = Pixmap.Format.toGlFormat(this.format);
        int glType = Pixmap.Format.toGlType(this.format);
        GLOnlyTextureData data = new GLOnlyTextureData(this.width, this.height, 0, glFormat, glFormat, glType);
        Texture result2 = new Texture(data);
        result2.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        result2.setWrap(Texture.TextureWrap.ClampToEdge, Texture.TextureWrap.ClampToEdge);
        return result2;
    }

    @Override
    protected void disposeColorTexture(Texture colorTexture) {
        colorTexture.dispose();
    }

    public static void unbind() {
        GLFrameBuffer.unbind();
    }
}

